<?php

function get_url_ficha($atts)
{
$default = array(
        'identificador' => '',
    );
$data = shortcode_atts($default, $atts);
$identificador = $data['identificador'];
$page = get_posts([
    'post_type'   => 'page',
    'meta_key'    => 'nichecreator_identificador',
    'meta_value'  => "$identificador",
    'post_status' => 'publish',
    'numberposts' => 1
]);
if (!empty($page)) {
    $ficha = $page[0]; 
    $url = get_permalink($ficha->ID);
    return $url;
} else {
    return;
}
}

add_shortcode('get_url_ficha', 'get_url_ficha');

function get_titulo_ficha($atts) {
 $default = array(
        'identificador' => '',
        'nombre' => '',
    );
$data = shortcode_atts($default, $atts);
$identificador = $data['identificador'];
$nombre = $data['nombre'];
    $page = get_posts([
        'post_type'   => 'page',
        'meta_key'    => 'nichecreator_identificador',
        'meta_value'  => "$identificador",
        'post_status' => 'publish',
        'numberposts' => 1
    ]);
    // Si encontramos la página
    if (!empty($page)) {
        $ficha = $page[0]; // Obtenemos la primera página
        $url = get_permalink($ficha->ID); // Obtener la URL de la página
        $titulo = $ficha->post_title; // Obtener el título de la página

        // Crear el enlace con el título de la página
        return '<a href="' . esc_url($url) . '">' . esc_html($titulo) . '</a>';
    } else {
        return $nombre;
    }
}
add_shortcode('get_titulo_ficha', 'get_titulo_ficha');


/**
 * Shortcode: [get_boton_ficha identificador="123"]
 * Opciones extra:
 *   background  → color de fondo (defecto #ff7a00)
 *   color       → color del texto (defecto #ffffff)
 *   padding     → padding CSS (defecto 12px 24px)
 *   label       → texto del botón (por defecto, el título de la ficha)
 */
function get_boton_ficha( $atts ) {

    $defaults = array(
        'identificador' => '',
        'background'    => '#ff7a00', // naranja por defecto
        'color'         => '#ffffff', // texto blanco
        'padding'       => '12px 24px',
        'label'         => '',        // opcional: texto del botón
    );
    $attr = shortcode_atts( $defaults, $atts );

    // Buscamos la ficha
    $pages = get_posts( array(
        'post_type'   => 'page',
        'meta_key'    => 'nichecreator_identificador',
        'meta_value'  => $attr['identificador'],
        'post_status' => 'publish',
        'numberposts' => 1,
    ) );

    if ( empty( $pages ) ) {
        return ''; // Nada de nada si no existe la ficha
    }

    $ficha   = $pages[0];
    $url     = get_permalink( $ficha->ID );
    $titulo  = $ficha->post_title;
    $label   = $attr['label'] !== '' ? $attr['label'] : $titulo;

    $style = sprintf(
        'width:100%%;text-align:center;border-radius:6px;' .
        'background-color:%1$s;color:%2$s;padding:%3$s;' .
        'text-decoration:none;display:inline-block;font-weight:600;',
        esc_attr( $attr['background'] ),
        esc_attr( $attr['color'] ),
        esc_attr( $attr['padding'] )
    );

    return '<a href="' . esc_url( $url ) . '" style="' . $style . '">' . esc_html( $label ) . '</a>';
}
add_shortcode( 'get_boton_ficha', 'get_boton_ficha' );


/**
 * Shortcode: [get_boton_home]
 * Opciones extra:
 *   background  → color de fondo (defecto #ff7a00)
 *   color       → color del texto (defecto #ffffff)
 *   padding     → padding CSS (defecto 12px 24px)
 *   label       → texto del botón (defecto: "Ir a la página principal")
 */
function get_boton_home( $atts ) {

    $defaults = array(
        'background' => '#ff7a00', // naranja por defecto
        'color'      => '#ffffff', // texto blanco
        'padding'    => '12px 24px',
        'label'      => 'Ver más',
    );
    $attr = shortcode_atts( $defaults, $atts );

    $url   = home_url();
    $label = $attr['label'];
    
    $style = sprintf(
        'width:100%%;text-align:center;border-radius:6px;' . // nuevos estilos
        'background-color:%1$s;color:%2$s;padding:%3$s;' .
        'text-decoration:none;display:inline-block;font-weight:600;',
        esc_attr( $attr['background'] ),
        esc_attr( $attr['color'] ),
        esc_attr( $attr['padding'] )
    );

    return '<a href="' . esc_url( $url ) . '" style="' . $style . '">' . esc_html( $label ) . '</a>';
}
add_shortcode( 'get_boton_home', 'get_boton_home' );


function nc_get_children()
{
$contenido = '<div class="clusterhijos" style="margin-top:20px;margin-bottom:20px;display:flex;flex-direction:row;flex-wrap:wrap;align-items:stretch;align-content:center;gap:10px;">';
$pageID = get_queried_object_id();
$child_pages = get_children( array( 'post_parent' => $pageID ) );
$clusterdesc = get_option('nichecreator_clusterdesc','No');
$clusterchars = get_option('nichecreator_clusterchars',50);
$clusterimagen = get_option('nichecreator_clusterimagen','No');
foreach ($child_pages as $child)
{
/*
    $childID = $child->ID;
    $fichas = get_children(array('post_parent'=>$childID));
    if (empty($fichas))
        continue;
*/
    $link = get_permalink($child->ID);
    $titulo = get_the_title($child->ID);
    if ($clusterimagen == 'Si')
        $imagen = get_the_post_thumbnail($child->ID,array(100,100));
    else $imagen = '';
    if ($clusterdesc == 'Si')
        {
        $descrip = get_post_meta($child->ID,'nichecreator_descripcion',true);
        
        if ($descrip == '')
            $descrip = get_the_excerpt($child->ID);
        $descrip = RecortTexto($descrip, $clusterchars);
        $contenido = $contenido .'<div class="child" style="padding:20px;border:1px solid black;border-radius:10px;flex:1 0 25%;">'.$imagen.'<a href="'.$link.'">'.ucfirst($titulo).'</a><span class="descripcion">'.$descrip.'</span></div>';
        }
    else 
    $contenido = $contenido .'<div class="child" style="padding:20px;border:1px solid black;border-radius:10px;flex:1 0 25%;">'.$imagen.'<a href="'.$link.'">'.ucfirst($titulo).'</a><br/></div>';
}
$contenido = $contenido. '</div>';
return $contenido;
}

add_shortcode('nc_get_children','nc_get_children');

function nc_get_tag()
{
$pageID = get_queried_object_id();
$numfichas = get_post_meta($pageID,'nichecreator_fichascategoria',true);
$child_count = new WP_Query( array(
    'post_type'      => 'page',
    'post_parent'    => $pageID,
    'posts_per_page' => -1,
    'fields'         => 'ids', // Solo devuelve los IDs, más ligero
    'post_status'    => 'publish'
) );
$contador = $child_count->post_count;
if ($contador > $numfichas)
{
$etiqueta = get_post_meta($pageID,'nichecreator_categoria',true);
$term = get_term_by('slug', $etiqueta, 'post_tag');
if ($term && !is_wp_error($term)) 
{
    $enlace = get_term_link($term);
    if (!is_wp_error($enlace)) {
        $contenidoboton = '<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"textAlign":"center","width":25,"className":"botonmas"} -->
<div class="wp-block-button has-custom-width wp-block-button__width-25 botonmas"><a class="wp-block-button__link has-text-align-center wp-element-button" href="'.$enlace.'">'. __("Ver todas las fichas","nichecreator").'</a></div><!-- /wp:button --></div><!-- /wp:buttons -->';
     return $contenidoboton;
    } else {
        error_log('Error en get_term_link: ' . $enlace->get_error_message());
        return;
    }
} else {
    //error_log("Término no encontrado: $etiqueta");
    return;
}
}
return;
}

add_shortcode('nc_get_tag','nc_get_tag');

// Recorta un texto a un determinado numero de caracteres

// El resultado casi nunca es exacto, y siempre algo menor al indicado.

// Esto ocurre por que se elimina la ultima palabra completa

// Tambien elimina etiquetas

// Funcion desarrollada por ArtesaniaWeb.ES



function RecortTexto($texto, $max_caract){

    $ntexto = strlen(strip_tags($texto));

    $res_texto = substr(strip_tags($texto), 0, $max_caract);

        if($ntexto <= $max_caract){

            $dev_texto = $res_texto;

        }else{

            // Asi eliminamos las palabras incompletas y el fastidioso simbolo ï¿½

            $array_texto = explode(' ', $res_texto);

            array_pop($array_texto);    // Elimina el ultimo elemento del array

            $recor_texto = implode(' ', $array_texto);

            $pu_susp = '...';

            $dev_texto = "$recor_texto$pu_susp";

        }

            return $dev_texto;

    }

function shortcode_osm_map($atts) {
    $atts = shortcode_atts(array(
        'nombre' => '',
        'direccion' => '',
        'ancho' => '100%',
        'alto' => '400px',
        'zoom' => 16,
        'icono' => '', // Esto ahora será un código de FontAwesome o Material Icon
    ), $atts, 'osm_map');

    $nombre = esc_html($atts['nombre']);
    $direccion = esc_html($atts['direccion']);
    $ancho = esc_attr($atts['ancho']);
    $alto = esc_attr($atts['alto']);
    $zoom = intval($atts['zoom']);
    $icono = esc_html($atts['icono']);

    $map_id = 'map_' . uniqid();

    ob_start();
    ?>
    <div style="width: <?php echo $ancho; ?>; height: <?php echo $alto; ?>;" id="<?php echo $map_id; ?>"></div>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            fetch("https://nominatim.openstreetmap.org/search?format=json&q=<?php echo urlencode($direccion); ?>")
                .then(response => response.json())
                .then(data => {
                    if (data.length > 0) {
                        const lat = data[0].lat;
                        const lon = data[0].lon;

                        // Asegurarse de que Leaflet esté cargado
                        if (typeof L !== 'undefined') {
                            const map = L.map('<?php echo $map_id; ?>').setView([lat, lon], <?php echo $zoom; ?>);

                            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                                attribution: '© OpenStreetMap contributors'
                            }).addTo(map);

                            <?php if ($icono): ?>
                            // Crear un icono con FontAwesome y quitar el cuadro blanco
                            const customIcon = L.divIcon({
                                className: 'leaflet-div-icon fa-icon',  // Le damos una clase personalizada
                                html: '<i class="fa <?php echo $icono; ?>"></i>',
                                iconSize: [32, 32], // Tamaño del icono
                                iconAnchor: [16, 32], // Punto de anclaje
                                popupAnchor: [0, -32] // Dónde aparece el popup en relación al icono
                            });
                            const marker = L.marker([lat, lon], { icon: customIcon }).addTo(map);
                            <?php else: ?>
                            const marker = L.marker([lat, lon]).addTo(map);
                            <?php endif; ?>

                            marker.bindPopup("<?php echo addslashes($nombre); ?><br><?php echo addslashes($direccion); ?>").openPopup();
                        } else {
                            console.error('Leaflet.js no se ha cargado correctamente.');
                        }
                    } else {
                        document.getElementById('<?php echo $map_id; ?>').innerHTML = "Dirección no encontrada.";
                    }
                });
        });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('osm_map', 'shortcode_osm_map');

function mapa_google_sin_api_shortcode($atts) {
    // Atributos del shortcode
    $atts = shortcode_atts(
        array(
            'direccion' => '', // Dirección del negocio
            'lat' => '',       // Latitud
            'lng' => '',       // Longitud
            'nombre' => '',    // Nombre del negocio
            'ancho' => '600',  // Ancho del mapa
            'alto' => '450'    // Alto del mapa
        ),
        $atts,
        'mapa_google' // Nombre del shortcode
    );

    // Si no se proporciona lat y lng, se usa la dirección para crear el enlace del mapa
    if (!empty($atts['direccion'])) {
        // Codificar la dirección para formar la URL del mapa
        $direccion = urlencode($atts['direccion']);
        $nombre = urlencode($atts['nombre']);
        $url_mapa = 'https://www.google.com/maps?q=' . $nombre.' '.$direccion . '&output=embed';
    } elseif (!empty($atts['lat']) && !empty($atts['lng'])) {
        // Si lat y lng están proporcionados, usar coordenadas para crear la URL
        $url_mapa = 'https://www.google.com/maps?q=' . $atts['lat'] . ',' . $atts['lng'] . '&z=15&output=embed';
    } else {
        return 'No se proporcionó una dirección ni coordenadas.';
    }

    // Generar el iframe con la URL
    $output = '<div>';
    $output .= '<iframe width="' . esc_attr($atts['ancho']) . '" height="' . esc_attr($atts['alto']) . '" src="' . esc_url($url_mapa) . '" frameborder="0" style="border:0" allowfullscreen></iframe></div>';

    return $output;
}


add_shortcode('mapa_google', 'mapa_google_sin_api_shortcode');



/**
 * Shortcode: [nc_cluster_abc]
 *
 * Atributos opcionales:
 *   id             → ID de la página cuyos hijos quieres listar (por defecto la actual).
 *   letter_bg      → color fondo botones (default #734864)
 *   letter_active  → color fondo botón activo (default #9a5b7d)
 *   letter_color   → color texto botón (default #ffffff)
 *   list_bg        → color fondo listado (default #f1f8f8)
 */
add_shortcode( 'nc_cluster_abc', 'nc_shortcode_cluster_abc' );

if ( ! function_exists( 'nc_shortcode_cluster_abc' ) ) {
    function nc_shortcode_cluster_abc( $atts = [] ) {

        /* ── Atributos de usuario ── */
        $atts = shortcode_atts( [
            'id'            => '',            // ID de página base (vacío ⇒ página actual)
            'letter_bg'     => '#734864',
            'letter_active' => '#9a5b7d',
            'letter_color'  => '#ffffff',
            'list_bg'       => '#f1f8f8',
        ], $atts, 'nc_cluster_abc' );

        $page_id = $atts['id'] !== '' ? intval( $atts['id'] ) : get_queried_object_id();
        if ( ! $page_id ) {
            return '<p>ID de página inválido.</p>';
        }

        /* ── Opciones de tu plugin ── */
        $show_desc  = get_option( 'nichecreator_clusterdesc',  'No' );
        $desc_len   = intval( get_option( 'nichecreator_clusterchars', 50 ) );
        $show_thumb = get_option( 'nichecreator_clusterimagen', 'No' );

        /* ── Hijos de la página base ── */
        $children = get_children( [
            'post_parent' => $page_id,
            'post_type'   => 'page',
            'meta_key'    => 'nichecreator_categoria',
            'orderby'     => 'meta_value',
            'order'       => 'ASC',
            'post_status' => 'publish',
            'numberposts' => -1,
        ] );

        if ( empty( $children ) ) {
            return '<p>No se encontraron municipios.</p>';
        }

        /* ── Agrupar por letra ── */
        $by_letter = [];
        foreach ( $children as $child ) {
            $cat = get_post_meta( $child->ID, 'nichecreator_categoria', true );
            $cat = $cat !== '' ? $cat : get_the_title( $child->ID );
            //$ltr = strtoupper( mb_substr( $cat, 0, 1 ) );
			$ltr = nc_normaliza_letra( $cat );
            $by_letter[ $ltr ][] = [ 'post' => $child, 'cat' => $cat ];
        }
        $first_open = array_key_first( $by_letter );

        /* ── ID único para estilos/JS por instancia ── */
        $uid = 'ncabc-' . uniqid();

        /* ── Render ── */
        ob_start(); ?>
        <div id="<?php echo esc_attr( $uid ); ?>" class="nc-cluster-abc"
             style="
                --nc-letter-bg:     <?php echo esc_attr( $atts['letter_bg'] ); ?>;
                --nc-letter-active: <?php echo esc_attr( $atts['letter_active'] ); ?>;
                --nc-letter-color:  <?php echo esc_attr( $atts['letter_color'] ); ?>;
                --nc-list-bg:       <?php echo esc_attr( $atts['list_bg'] ); ?>;
             ">
            <!-- Navegación -->
            <div class="nc-letter-nav">
                <?php foreach ( range( 'A', 'Z' ) as $ltr ) :
                    if ( empty( $by_letter[ $ltr ] ) ) { continue; }
                    $active = ( $ltr === $first_open ); ?>
                    <button
                        class="nc-letter-toggle<?php echo $active ? ' is-active' : ''; ?>"
                        aria-expanded="<?php echo $active ? 'true' : 'false'; ?>"
                        aria-controls="<?php echo esc_attr( $uid . '-' . $ltr ); ?>">
                        <?php echo esc_html( $ltr ); ?>
                    </button>
                <?php endforeach; ?>
            </div>

            <!-- Listados -->
            <div class="nc-letter-content">
                <?php foreach ( $by_letter as $ltr => $items ) :
                    $open = ( $ltr === $first_open ); ?>
                    <div id="<?php echo esc_attr( $uid . '-' . $ltr ); ?>"
                         class="nc-letter-list<?php echo $open ? ' is-open' : ''; ?>">
                        <?php foreach ( $items as $item ) :
                            $child = $item['post'];
                            $cat   = $item['cat'];
                            $link  = get_permalink( $child->ID );
                            $thumb = ( $show_thumb === 'Si' )
                                ? get_the_post_thumbnail( $child->ID, [ 100, 100 ], [ 'loading' => 'lazy' ] )
                                : '';
                            $desc  = '';

                            if ( $show_desc === 'Si' ) {
                                $raw = get_post_meta( $child->ID, 'nichecreator_descripcion', true );
                                if ( $raw === '' ) { $raw = get_the_excerpt( $child->ID ); }
                                $desc = nc_recorta_texto( $raw, $desc_len );
                            } ?>
                            <div class="nc-child">
                                <?php echo $thumb; ?>
                                <a href="<?php echo esc_url( $link ); ?>">
                                    <?php // echo esc_html( ucfirst( $cat ) ); ?>
                                    <?php echo esc_html(mb_convert_case($cat, MB_CASE_TITLE, "UTF-8")); ?>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <style>
            /* ====== Estilos (variables por instancia) ====== */
            #<?php echo esc_attr( $uid ); ?> .nc-letter-nav              { text-align:center; margin-bottom:16px; }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-toggle           {
                background:var(--nc-letter-bg); color:var(--nc-letter-color);
                font-weight:700; border:0; padding:8px 14px; border-radius:4px;
                margin:4px; cursor:pointer; transition:background .2s;
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-toggle.is-active {
                background:var(--nc-letter-active);
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-content          { width:100%; }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-list             {
                display:none; padding:20px; background:var(--nc-list-bg);
                flex-wrap:wrap; gap:18px; justify-content:flex-start;
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-list.is-open     { display:flex; }
            #<?php echo esc_attr( $uid ); ?> .nc-child                   { flex:1 1 240px; min-width:200px; }
            #<?php echo esc_attr( $uid ); ?> .nc-child img               { display:block; margin:0 auto 6px; border-radius:4px; }
            #<?php echo esc_attr( $uid ); ?> .nc-child a                 { font-weight:600; color:#0066c0; text-align:center; display:block; margin-bottom:4px; }
            #<?php echo esc_attr( $uid ); ?> .nc-desc                    { font-size:0.9em; color:#555; text-align:center; }
        </style>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const container = document.getElementById('<?php echo esc_js( $uid ); ?>');
                if (!container) return;

                const toggles = container.querySelectorAll('.nc-letter-toggle');
                toggles.forEach(btn => {
                    btn.addEventListener('click', () => {
                        /* Cerrar listados */
                        toggles.forEach(b => {
                            b.setAttribute('aria-expanded', 'false');
                            b.classList.remove('is-active');
                            container.querySelector('#' + b.getAttribute('aria-controls')).classList.remove('is-open');
                        });
                        /* Abrir el seleccionado */
                        btn.setAttribute('aria-expanded', 'true');
                        btn.classList.add('is-active');
                        container.querySelector('#' + btn.getAttribute('aria-controls')).classList.add('is-open');
                    });
                });
            });
        </script>
        <?php
        return ob_get_clean();
    }
}

/**
 * Shortcode: [nc_cluster_abc_parents]
 *
 * Agrupa alfabéticamente *todos* los posts/páginas que posean el meta
 * nichecreator_categoria y no contengan nichecreator_categoriapadre (porque son padres).
 *
 * Atributos opcionales:
 *   post_type      → tipo de post (default 'page')
 *   letter_bg      → color fondo botones (default #734864)
 *   letter_active  → color fondo botón activo (default #9a5b7d)
 *   letter_color   → color texto botón (default #ffffff)
 *   list_bg        → color fondo listado (default #f1f8f8)
 */
add_shortcode( 'nc_cluster_abc_parents', 'nc_shortcode_cluster_abc_parents' );

if ( ! function_exists( 'nc_shortcode_cluster_abc_parents' ) ) {
    function nc_shortcode_cluster_abc_parents( $atts = [] ) {

        /* ── Atributos de usuario ── */
        $atts = shortcode_atts( [
            'post_type'     => 'page',
            'letter_bg'     => '#734864',
            'letter_active' => '#9a5b7d',
            'letter_color'  => '#ffffff',
            'list_bg'       => '#f1f8f8',
        ], $atts, 'nc_cluster_abc_parents' );

        /* ── Opciones de tu plugin ── */
        $show_desc  = get_option( 'nichecreator_clusterdesc',  'No' );
        $desc_len   = intval( get_option( 'nichecreator_clusterchars', 50 ) );
        $show_thumb = get_option( 'nichecreator_clusterimagen', 'No' );

        /* ── Todos los posts con nichecreator_categoria ── */
        $posts = get_posts( [
    'post_type'      => $atts['post_type'],
    'post_status'    => 'publish',
    'posts_per_page' => -1,
    'orderby'        => 'meta_value',
    'order'          => 'ASC',
    'nopaging'       => true,
    'meta_query'     => [
        'relation' => 'AND',
        [
            'key'     => 'nichecreator_categoria',
            'compare' => 'EXISTS',
        ],
        [
            'key'     => 'nichecreator_categoriapadre',
            'compare' => 'NOT EXISTS',
        ],
    ],
] );
        if ( empty( $posts ) ) {
            return '<p>No se encontraron elementos.</p>';
        }

        /* ── Agrupar por letra ── */
        $by_letter = [];
        foreach ( $posts as $p ) {
            $cat = get_post_meta( $p->ID, 'nichecreator_categoria', true );
            $cat = $cat !== '' ? $cat : get_the_title( $p->ID );
            //$ltr = strtoupper( mb_substr( $cat, 0, 1 ) );
			$ltr = nc_normaliza_letra( $cat );
            $by_letter[ $ltr ][] = [ 'post' => $p, 'cat' => $cat ];
        }
        $first_open = array_key_first( $by_letter );

        /* ── ID único por instancia ── */
        $uid = 'ncabc-' . uniqid();

        /* ── Render ── */
        ob_start(); ?>
        <div id="<?php echo esc_attr( $uid ); ?>" class="nc-cluster-abc"
             style="
                --nc-letter-bg:     <?php echo esc_attr( $atts['letter_bg'] ); ?>;
                --nc-letter-active: <?php echo esc_attr( $atts['letter_active'] ); ?>;
                --nc-letter-color:  <?php echo esc_attr( $atts['letter_color'] ); ?>;
                --nc-list-bg:       <?php echo esc_attr( $atts['list_bg'] ); ?>;
             ">
            <!-- Navegación -->
            <div class="nc-letter-nav">
                <?php foreach ( range( 'A', 'Z' ) as $ltr ) :
                    if ( empty( $by_letter[ $ltr ] ) ) { continue; }
                    $active = ( $ltr === $first_open ); ?>
                    <button
                        class="nc-letter-toggle<?php echo $active ? ' is-active' : ''; ?>"
                        aria-expanded="<?php echo $active ? 'true' : 'false'; ?>"
                        aria-controls="<?php echo esc_attr( $uid . '-' . $ltr ); ?>">
                        <?php echo esc_html( $ltr ); ?>
                    </button>
                <?php endforeach; ?>
            </div>

            <!-- Listados -->
            <div class="nc-letter-content">
                <?php foreach ( $by_letter as $ltr => $items ) :
                    $open = ( $ltr === $first_open ); ?>
                    <div id="<?php echo esc_attr( $uid . '-' . $ltr ); ?>"
                         class="nc-letter-list<?php echo $open ? ' is-open' : ''; ?>">
                        <?php foreach ( $items as $item ) :
                            $p     = $item['post'];
                            $cat   = $item['cat'];
                            $link  = get_permalink( $p->ID );
                            $thumb = ( $show_thumb === 'Si' )
                                ? get_the_post_thumbnail( $p->ID, [ 100, 100 ], [ 'loading' => 'lazy' ] )
                                : '';
                            $desc  = '';

                            if ( $show_desc === 'Si' ) {
                                $raw = get_post_meta( $p->ID, 'nichecreator_descripcion', true );
                                if ( $raw === '' ) { $raw = get_the_excerpt( $p->ID ); }
                                $desc = nc_recorta_texto( $raw, $desc_len );
                            } ?>
                            <div class="nc-child">
                                <?php echo $thumb; ?>
                                <a href="<?php echo esc_url( $link ); ?>">
                                    <?php //echo esc_html( ucfirst( $cat ) ); ?>
                                    <?php echo esc_html(mb_convert_case($cat, MB_CASE_TITLE, "UTF-8")); ?>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <style>
            /* ====== Estilos (variables por instancia) ====== */
            #<?php echo esc_attr( $uid ); ?> .nc-letter-nav              { text-align:center; margin-bottom:16px; }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-toggle           {
                background:var(--nc-letter-bg); color:var(--nc-letter-color);
                font-weight:700; border:0; padding:8px 14px; border-radius:4px;
                margin:4px; cursor:pointer; transition:background .2s;
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-toggle.is-active {
                background:var(--nc-letter-active);
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-content          { width:100%; }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-list             {
                display:none; padding:20px; background:var(--nc-list-bg);
                flex-wrap:wrap; gap:18px; justify-content:flex-start;
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-list.is-open     { display:flex; }
            #<?php echo esc_attr( $uid ); ?> .nc-child                   { flex:1 1 240px; min-width:200px; }
            #<?php echo esc_attr( $uid ); ?> .nc-child img               { display:block; margin:0 auto 6px; border-radius:4px; }
            #<?php echo esc_attr( $uid ); ?> .nc-child a                 { font-weight:600; color:#0066c0; text-align:center; display:block; margin-bottom:4px; }
            #<?php echo esc_attr( $uid ); ?> .nc-desc                    { font-size:0.9em; color:#555; text-align:center; }
        </style>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const container = document.getElementById('<?php echo esc_js( $uid ); ?>');
                if (!container) return;

                const toggles = container.querySelectorAll('.nc-letter-toggle');
                toggles.forEach(btn => {
                    btn.addEventListener('click', () => {
                        /* Cerrar listados */
                        toggles.forEach(b => {
                            b.setAttribute('aria-expanded', 'false');
                            b.classList.remove('is-active');
                            container.querySelector('#' + b.getAttribute('aria-controls')).classList.remove('is-open');
                        });
                        /* Abrir el seleccionado */
                        btn.setAttribute('aria-expanded', 'true');
                        btn.classList.add('is-active');
                        container.querySelector('#' + btn.getAttribute('aria-controls')).classList.add('is-open');
                    });
                });
            });
        </script>
        <?php
        return ob_get_clean();
    }
}




/**
 * Shortcode: [nc_cluster_abc_all]
 *
 * Agrupa alfabéticamente *todos* los posts/páginas que posean el meta
 * nichecreator_categoria.
 *
 * Atributos opcionales:
 *   post_type      → tipo de post (default 'page')
 *   letter_bg      → color fondo botones (default #734864)
 *   letter_active  → color fondo botón activo (default #9a5b7d)
 *   letter_color   → color texto botón (default #ffffff)
 *   list_bg        → color fondo listado (default #f1f8f8)
 */
add_shortcode( 'nc_cluster_abc_all', 'nc_shortcode_cluster_abc_all' );

if ( ! function_exists( 'nc_shortcode_cluster_abc_all' ) ) {
    function nc_shortcode_cluster_abc_all( $atts = [] ) {

        /* ── Atributos de usuario ── */
        $atts = shortcode_atts( [
            'post_type'     => 'page',
            'letter_bg'     => '#734864',
            'letter_active' => '#9a5b7d',
            'letter_color'  => '#ffffff',
            'list_bg'       => '#f1f8f8',
        ], $atts, 'nc_cluster_abc_all' );

        /* ── Opciones de tu plugin ── */
        $show_desc  = get_option( 'nichecreator_clusterdesc',  'No' );
        $desc_len   = intval( get_option( 'nichecreator_clusterchars', 50 ) );
        $show_thumb = get_option( 'nichecreator_clusterimagen', 'No' );

        /* ── Todos los posts con nichecreator_categoria ── */
        $posts = get_posts( [
            'post_type'      => $atts['post_type'],
            'post_status'    => 'publish',
            'posts_per_page' => -1,
            'meta_key'       => 'nichecreator_categoria',
            'meta_compare'   => 'EXISTS',
            'orderby'        => 'meta_value',
            'order'          => 'ASC',
            'nopaging'       => true,
        ] );

        if ( empty( $posts ) ) {
            return '<p>No se encontraron elementos.</p>';
        }

        /* ── Agrupar por letra ── */
        $by_letter = [];
        foreach ( $posts as $p ) {
            $cat = get_post_meta( $p->ID, 'nichecreator_categoria', true );
            $cat = $cat !== '' ? $cat : get_the_title( $p->ID );
            //$ltr = strtoupper( mb_substr( $cat, 0, 1 ) );
			$ltr = nc_normaliza_letra( $cat );
            $by_letter[ $ltr ][] = [ 'post' => $p, 'cat' => $cat ];
        }
        $first_open = array_key_first( $by_letter );

        /* ── ID único por instancia ── */
        $uid = 'ncabc-' . uniqid();

        /* ── Render ── */
        ob_start(); ?>
        <div id="<?php echo esc_attr( $uid ); ?>" class="nc-cluster-abc"
             style="
                --nc-letter-bg:     <?php echo esc_attr( $atts['letter_bg'] ); ?>;
                --nc-letter-active: <?php echo esc_attr( $atts['letter_active'] ); ?>;
                --nc-letter-color:  <?php echo esc_attr( $atts['letter_color'] ); ?>;
                --nc-list-bg:       <?php echo esc_attr( $atts['list_bg'] ); ?>;
             ">
            <!-- Navegación -->
            <div class="nc-letter-nav">
                <?php foreach ( range( 'A', 'Z' ) as $ltr ) :
                    if ( empty( $by_letter[ $ltr ] ) ) { continue; }
                    $active = ( $ltr === $first_open ); ?>
                    <button
                        class="nc-letter-toggle<?php echo $active ? ' is-active' : ''; ?>"
                        aria-expanded="<?php echo $active ? 'true' : 'false'; ?>"
                        aria-controls="<?php echo esc_attr( $uid . '-' . $ltr ); ?>">
                        <?php echo esc_html( $ltr ); ?>
                    </button>
                <?php endforeach; ?>
            </div>

            <!-- Listados -->
            <div class="nc-letter-content">
                <?php foreach ( $by_letter as $ltr => $items ) :
                    $open = ( $ltr === $first_open ); ?>
                    <div id="<?php echo esc_attr( $uid . '-' . $ltr ); ?>"
                         class="nc-letter-list<?php echo $open ? ' is-open' : ''; ?>">
                        <?php foreach ( $items as $item ) :
                            $p     = $item['post'];
                            $cat   = $item['cat'];
                            $link  = get_permalink( $p->ID );
                            $thumb = ( $show_thumb === 'Si' )
                                ? get_the_post_thumbnail( $p->ID, [ 100, 100 ], [ 'loading' => 'lazy' ] )
                                : '';
                            $desc  = '';

                            if ( $show_desc === 'Si' ) {
                                $raw = get_post_meta( $p->ID, 'nichecreator_descripcion', true );
                                if ( $raw === '' ) { $raw = get_the_excerpt( $p->ID ); }
                                $desc = nc_recorta_texto( $raw, $desc_len );
                            } ?>
                            <div class="nc-child">
                                <?php echo $thumb; ?>
                                <a href="<?php echo esc_url( $link ); ?>">
                                    <?php //echo esc_html( ucfirst( $cat ) ); ?>
                                    <?php echo esc_html(mb_convert_case($cat, MB_CASE_TITLE, "UTF-8")); ?>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <style>
            /* ====== Estilos (variables por instancia) ====== */
            #<?php echo esc_attr( $uid ); ?> .nc-letter-nav              { text-align:center; margin-bottom:16px; }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-toggle           {
                background:var(--nc-letter-bg); color:var(--nc-letter-color);
                font-weight:700; border:0; padding:8px 14px; border-radius:4px;
                margin:4px; cursor:pointer; transition:background .2s;
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-toggle.is-active {
                background:var(--nc-letter-active);
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-content          { width:100%; }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-list             {
                display:none; padding:20px; background:var(--nc-list-bg);
                flex-wrap:wrap; gap:18px; justify-content:flex-start;
            }
            #<?php echo esc_attr( $uid ); ?> .nc-letter-list.is-open     { display:flex; }
            #<?php echo esc_attr( $uid ); ?> .nc-child                   { flex:1 1 240px; min-width:200px; }
            #<?php echo esc_attr( $uid ); ?> .nc-child img               { display:block; margin:0 auto 6px; border-radius:4px; }
            #<?php echo esc_attr( $uid ); ?> .nc-child a                 { font-weight:600; color:#0066c0; text-align:center; display:block; margin-bottom:4px; }
            #<?php echo esc_attr( $uid ); ?> .nc-desc                    { font-size:0.9em; color:#555; text-align:center; }
        </style>

        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const container = document.getElementById('<?php echo esc_js( $uid ); ?>');
                if (!container) return;

                const toggles = container.querySelectorAll('.nc-letter-toggle');
                toggles.forEach(btn => {
                    btn.addEventListener('click', () => {
                        /* Cerrar listados */
                        toggles.forEach(b => {
                            b.setAttribute('aria-expanded', 'false');
                            b.classList.remove('is-active');
                            container.querySelector('#' + b.getAttribute('aria-controls')).classList.remove('is-open');
                        });
                        /* Abrir el seleccionado */
                        btn.setAttribute('aria-expanded', 'true');
                        btn.classList.add('is-active');
                        container.querySelector('#' + btn.getAttribute('aria-controls')).classList.add('is-open');
                    });
                });
            });
        </script>
        <?php
        return ob_get_clean();
    }
}


/* Helper para corte de texto */
if ( ! function_exists( 'nc_recorta_texto' ) ) {
    function nc_recorta_texto( $txt, $len = 50 ) {
        $txt = wp_strip_all_tags( $txt );
        if ( mb_strlen( $txt ) <= $len ) { return $txt; }
        $cut = mb_substr( $txt, 0, $len );
        $space = mb_strrpos( $cut, ' ' );
        if ( $space !== false ) { $cut = mb_substr( $cut, 0, $space ); }
        return $cut . '…';
    }
}
