<?php
/*
Plugin Name: Niche Creator
Plugin URI: https://niche-creator.com/
Description: La navaja suiza de los directorios
Version: 1.2.0
Author: Niche Creator
Author URI: https://niche-creator.com/
Text Domain: nichecreator
Domain Path: /languages/
*/
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


// CONSTANTES /
//define( 'NC_STORE_URL', 'https://niche-creator.com' ); 
//define( 'NC_ID', 9108 ); 
//define( 'NC_ITEM', 'Niche Creator' );
define('NICHECREATOR_VERSION','1.2.0');
define( 'NC_STORE_URL', 'https://niche-creator.com/es' ); 
define( 'NC_ID', 8979 ); 
define( 'NC_ITEM', 'Niche Creator' );
define( 'NC_LICENSE_PAGE', 'nichecreator_license' );
define('NC_FILE', __FILE__);
define('CAMPOS',array("nombre"=>"OrganizationName","valoracion"=>"RateStars","reviews"=>"ReviewsTotalCount","direccion"=>"OrganizationAddress","municipio"=>"municipio","provincia"=>"provincia",
				"cp"=>"CP","website"=>"OrganizationWebsite","telefono"=>"OrganizationPhoneNr","horario"=>"OrganizationWorkTime","latitud"=>"OrganizationLatitude","longiutd"=>"OrganizationLongitude",
				"foto"=>"OrganizationHeadPhotoURL","fotos"=>"OrganizationPhotosURLs","email"=>"OrganizationEmail","categoria"=>"SearchRequest","categoriapadre"=>"categoriapadre","etiqueta"=>"etiqueta",
				"mapaiframe"=>"EmbedMapCode","link"=>"GMapsLink","metatitle"=>"metatitle","metadesc"=>"metadesc","h1"=>"h1","slug"=>"slug","miga"=>"migapan","lunes"=>"lunes","martes"=>"martes","miercoles"=>"miercoles",
				"jueves"=>"jueves","viernes"=>"viernes","sabado"=>"sabado","domingo"=>"domingo","var1"=>"var1","var2"=>"var2","var3"=>"var3","var4"=>"var4","var5"=>"var5","var6"=>"var6",
				"var7"=>"var7","var8"=>"var8","var9"=>"var9","var10"=>"var10","GoogleMpasID"=>"gmapsid","keyword"=>"keyword"));
define('PAGINAS_VALIDAS',array(
        'nichecreator_datos',
        'nichecreator_editor',
        'nichecreator_limpieza',
        'nichecreator_settingscat',
        'nichecreator_imagenes',
        'nichecreator_creator',
        'nichecreator_creator_pages'
    ));
	
/* --------------------------------------------------------------------
 *  REQUISITOS MÍNIMOS  –  PHP 8.1-8.3 + IonCube Loader
 * ------------------------------------------------------------------ */

/**
 * Comprueba los dos nombres habituales de la extensión
 *
 * @return bool
 */
function nc_has_ioncube() {
	return extension_loaded( 'ionCube Loader' ) || extension_loaded( 'ioncube_loader' );
}

/**
 * Comprueba los requisitos y, si hay errores, muestra wp_die()
 *
 * @param bool $only_on_activation  Si true, solo se usa en el activation-hook.
 */
function nc_check_requirements( $only_on_activation = false ) {

	$errors = [];

	/* 1 ▸ Versión de PHP */
	// Solo aceptamos PHP 8.1 – 8.3
	if ( PHP_VERSION_ID < 80100 || PHP_VERSION_ID >= 80400 ) {
	 $errors[] = sprintf('Niche Creator requiere PHP <strong>8.1</strong> / <strong>8.2</strong> o <strong>8.3</strong>. Tu servidor ejecuta la versión <strong>%s</strong>, que no es compatible.',PHP_VERSION);
	}
	/* 2 ▸ IonCube Loader */
	if ( ! nc_has_ioncube() ) {
		$errors[] = 'Niche Creator requiere que la extensión <strong>IonCube Loader</strong> esté activa en la versión de PHP que usas, y actualmente <strong>no está activa</strong>.';
	}

	/* 3 ▸ Si todo OK → salimos */
	if ( empty( $errors ) ) {
		return;
	}

	/* 4 ▸ Si estamos en activación, evitamos que se marque el plugin como activo */
	if ( $only_on_activation ) {
		deactivate_plugins( plugin_basename( __FILE__ ) );
	}

	/* 5 ▸ Construimos mensaje bonito */
	$logo = '<p style="text-align:center;"><img src="' .
		esc_url( plugins_url( 'img/logo.png', __FILE__ ) ) .
		'" alt="Niche Creator" width="200"  style="margin-bottom:1rem!important;"></p>';

	$count   = count( $errors );
	$message = $logo;
	$message .= '<p>Se ha detectado ' . $count . ' problema' . ( $count > 1 ? 's' : '' ) . ' en tu configuración:</p>';
	$message .= '<ul style="list-style-type:disc;margin-left:20px;">';
	foreach ( $errors as $error ) {
		$message .= '<li>' . $error . '</li>';
	}
	$message .= '</ul>';
	$message .= '<p>Contacta con tu proveedor de hosting para solucionarlo indicando el mensaje de arriba y poder aprovechar todas las funciones de Niche Creator.</p>';
	$message .= '<p>¿Dudas? Abre un ticket de soporte y te ayudaremos.</p>';
	$message .= '<p><a href="' . esc_url( admin_url( 'plugins.php' ) ) . '">Volver al listado de plugins</a></p>';

	wp_die( $message, 'Requisitos no cumplidos' );
}



/* ------- Corte temprano si el servidor no cumple ------- */
/* ------- Corte temprano si el servidor no cumple ------- */

if ( PHP_VERSION_ID < 80100 || PHP_VERSION_ID >= 80400 || ! nc_has_ioncube() ) {

	add_action( 'admin_notices', function () {
		echo '<div class="notice notice-error"><p>';
		esc_html_e(
			'Niche Creator no puede ejecutarse porque tu servidor no cumple los requisitos mínimos (PHP 8.1-8.3 + IonCube Loader).',
			'nichecreator'
		);
		echo '</p></div>';
	} );

	// Paramos aquí para que el resto del plugin no se cargue
	return;
}


/* ------------- FIN del bloque de requisitos ------------- */

////////////////////////////////////////////////////
//////////////// HOOKS ///////////////////////////
////////////////////////////////////////////////
function niche_install()
{
require_once 'activador.php';
}
register_activation_hook(__FILE__,'niche_install');

// ACTIVACION O UPGRADE/////
register_activation_hook( __FILE__, function () {
  nc_check_requirements( true ); // se ejecuta SOLO al activar
} );

require_once 'includes/cache.php';

register_activation_hook(__FILE__, 'nichecreator_cargageografica');

function nichecreator_cargageografica() {
	nichecreator_verificar_o_crear_tabla();
	nichecreator_verificar_escrapeos();
	actualizar_escrapeo_inicial();
    if (!as_has_scheduled_action('nichecreator_cargageografica')) {
        as_schedule_single_action(time() + 10, 'nichecreator_cargageografica');
    }
}

add_action('upgrader_process_complete', 'nichecreator_after_plugin_update', 10, 2);
function nichecreator_after_plugin_update($upgrader_object, $options) {
    error_log('🔍 Opciones del actualizador: ' . print_r($options, true));
    // Verificar si 'plugins' existe antes de acceder
    if (isset($options['plugins']) && is_array($options['plugins'])) {
        if ($options['action'] === 'update' && $options['type'] === 'plugin') {
            if (in_array(plugin_basename(__FILE__), $options['plugins'])) {
                error_log('⚙️ Plugin Niche Creator actualizado, ejecutando lógica...');
                nichecreator_cargageografica();
                //nichecreator_verificar_escrapeos();
            }
        }
    } else {
        error_log('⚠️ No se encontró la clave "plugins" en las opciones de actualización');
    }
}
add_action('admin_init', 'nichecreator_detectar_upgrade_manual');

function nichecreator_detectar_upgrade_manual() {
    $version_guardada = get_option('nichecreator_version');
    $version_actual = NICHECREATOR_VERSION;

    if ($version_guardada !== $version_actual) {
        // ⚠️ Lógica de instalación/upgrade
        error_log("📦 Versión actualizada desde $version_guardada a $version_actual");

        // Ejecuta tu lógica
        nichecreator_cargageografica();

        // Guarda la nueva versión
        update_option('nichecreator_version', $version_actual);
    }
}


// DESACTIVACION //
function niche_deactivation()
{
flush_rewrite_rules();
//delete_option('nichecreator_datosgeo');
}
register_deactivation_hook(__FILE__,'niche_deactivation');

// DESINSTALACION ////
function niche_uninstall()
{
require_once 'uninstall.php';
}
register_uninstall_hook(__FILE__,'niche_uninstall');

// INTERNACIONALIZACION Y LOCALIZACION
add_action( 'plugins_loaded', 'cargar_idioma2' );
function cargar_idioma2() {
    //load_plugin_textdomain( 'nichecreator', false, plugin_dir_path(__FILE__) . 'languages' );
	load_plugin_textdomain( 'nichecreator', false, plugin_basename(dirname(__FILE__)) . '/languages' );

}

/// TEMPORIZADOR ACTION SCHEDULER ////////////////////
add_action( 'init', 'ashp_register_custom_timeouts', 1 );
function ashp_register_custom_timeouts() {
    add_filter( 'action_scheduler_timeout_period', function($timeout) {
        return 600;
    }, PHP_INT_MAX );

    add_filter( 'action_scheduler_failure_period', function($timeout) {
        return 600;
    }, PHP_INT_MAX );
    
    // Tiempo total que el runner tiene para procesar acciones en una ejecución
    add_filter( 'action_scheduler_queue_runner_time_limit', function( $limit ) {
        return 120; // 2 minutos
    }, PHP_INT_MAX );
}

// AÑADIR ETIQUETAS...
// add tag support to pages
function tags_support_all() {
	register_taxonomy_for_object_type('post_tag', 'page');
}

// ensure all tags are included in queries
function tags_support_query($wp_query) {
	if ($wp_query->get('tag')) $wp_query->set('post_type', 'any');
}

// tag hooks
add_action('init', 'tags_support_all');
add_action('pre_get_posts', 'tags_support_query');

// CHEQUEO DE CODIFICACION UTF-8
add_action( 'plugins_loaded', function() {
	global $wpdb;
	// Forzar SET NAMES utf8mb4 si DB_CHARSET no está bien
	if ( defined( 'DB_CHARSET' ) && strtolower( DB_CHARSET ) !== 'utf8mb4' ) {
		$wpdb->query( "SET NAMES 'utf8mb4'" );
	}
	// Ejecutar solo una vez
	if ( ! get_option( 'nichecreator_migracioncharset' ) ) {
		$db = DB_NAME;
		$prefix = $wpdb->prefix;

		$results = $wpdb->get_results("
			SELECT TABLE_NAME
			FROM information_schema.TABLES
			WHERE TABLE_SCHEMA = '{$db}'
			  AND TABLE_COLLATION NOT LIKE 'utf8mb4_%'
			  AND TABLE_NAME LIKE '{$prefix}%'
		");

		foreach ( $results as $row ) {
			$table = esc_sql( $row->TABLE_NAME );
			$wpdb->query( "ALTER TABLE `{$table}` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci" );
		}
		update_option( 'nichecreator_migracioncharset', 'X' );
	}
});





// setup the updater

if ( ! class_exists( 'NC_Plugin_Updater' ) ) {
	include plugin_dir_path(__FILE__).'/kude/NC_Plugin_Updater.php';
}


function nc_sl_sample_plugin_updater() {
$doing_cron = defined( 'DOING_CRON' ) && DOING_CRON;
	if ( ! current_user_can( 'manage_options' ) && ! $doing_cron ) {
		return;
	}

// retrieve our license key from the DB
$license_key = trim( get_option( 'nc_sample_license_key' ) ); 

$edd_updater = new NC_Plugin_Updater( NC_STORE_URL, NC_FILE, array(
	'version' 	=> NICHECREATOR_VERSION,		// current version number
	'license' 	=> $license_key,	// license key (used get_option above to retrieve from DB)
	'item_id'   => NC_ID,	// id of this plugin
	'author' 	=> 'Niche Creator',	// author of this plugin
        'beta'  => false                // set to true if you wish customers to receive update notifications of beta releases
) );
}
add_action( 'admin_init', 'nc_sl_sample_plugin_updater' );


add_filter('tiny_mce_before_init', function ($init) {
    $init['forced_root_block'] = ''; // No envolver en <p>
    $init['force_br_newlines'] = true;
    $init['force_p_newlines'] = false;
    return $init;
});

add_filter('upload_mimes', function($mimes) {
    if ( defined('DOING_CRON') && DOING_CRON ) {
        $mimes['webp'] = 'image/webp';
    }
    return $mimes;
});

////////////////CSS y JS///////////////////
// STEPS ///////////
function encolar_metro_steps_script() {
    // Páginas del plugin donde quieres cargar el script
// Si no hay ?page=… devolvemos cadena vacía
	$pagina = isset( $_GET['page'] ) ? sanitize_key( $_GET['page'] ) : '';

	// Cargamos el JS solo en las páginas del plugin
	if ( in_array( $pagina, PAGINAS_VALIDAS, true ) ) {
		wp_enqueue_script('metro-steps',plugins_url( 'js/metro-steps.js', __FILE__ ),[ 'jquery' ],'1.1',true);
	}
}
add_action('admin_enqueue_scripts', 'encolar_metro_steps_script');

add_action( 'wp_enqueue_scripts', 'carga_cssfront' );
function carga_cssfront() 
{
wp_register_style('cluster',plugins_url('/css/cluster.css',__FILE__),'','1.4');
wp_enqueue_style('cluster');
wp_register_style('nichecreator',plugins_url('/css/nichecreator.css',__FILE__),'','1.4');
	wp_enqueue_style('nichecreator');
	if (is_singular())
	{
	global $post;
if ($post && has_shortcode($post->post_content, 'osm_map')) {
		wp_enqueue_style('leaflet-css', 'https://unpkg.com/leaflet/dist/leaflet.css',[]);
		//wp_enqueue_style('leaflet-css', 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.css');
        wp_enqueue_script('leaflet-js', 'https://unpkg.com/leaflet/dist/leaflet.js', [], null, true);
		 wp_enqueue_style('fontawesome-nc', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css',[]); 
	}
	}
}

add_action( 'admin_enqueue_scripts', 'carga_css' );
function carga_css() {
    // Traducciones para JS
    $botones = [
        'texto' => __('Introduce valor', 'nichecreator'),
    ];
    $translations = [
        'confirmar' => __('Confirmar', 'nichecreator'),
        'cancelar' => __('Cancelar', 'nichecreator'),
        'confirmacion_necesaria' => __('Confirmación necesaria', 'nichecreator'),
        'contenido' => __('Vas a lanzar el proceso de creación de fichas. Dependiendo del número de fichas, este proceso puede ser más o menos largo. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso.<strong>Si has seleccionado Ficha de Prueba, solamente se creará una.<strong>', 'nichecreator'),
        'contenidoia' => __('Vas a lanzar el proceso de creación de contenido. Dependiendo del número de keywords, este proceso puede ser más o menos largo. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso.', 'nichecreator'),
        'contenidokws' => __('Vas a lanzar el proceso de búsqueda de keywords. Este proceso es dependiente de Google Adwords, por lo que tienes que estar conectado para llevarlo a cabo.', 'nichecreator'),
        'contenidocanibal' => __('Vas a lanzar el proceso de detección de canibalizaciones. Dependiendo del número de entradas, este proceso puede ser más o menos largo. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso.', 'nichecreator'),
        'contenidolimpiarkws' => __('Vas a lanzar el proceso de borrado de keywords. Dependiendo del número de entradas, este proceso puede ser más o menos largo.', 'nichecreator'),
        'contenidoborrarduplis' => __('Vas a lanzar el proceso de borrado de keywords canibalizadas. Dependiendo del número de entradas, este proceso puede ser más o menos largo.', 'nichecreator'),
        'contenidotabla' => __('Vas a lanzar el proceso de creación de entradas. Dependiendo del número de entradas, este proceso puede ser más o menos largo. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso.', 'nichecreator'),
        'contenidotablakw' => __('Vas a lanzar el proceso de carga de keywords. Dependiendo del número de keywords, este proceso puede ser más o menos largo. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso.', 'nichecreator'),
        'contenidocats' => __('Vas a lanzar el proceso de regeneración de categorias. Dependiendo del número de categorías, este proceso puede ser más o menos largo. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso. <strong>Si has elegido lanzar categorías de prueba, se generará una única categoría padre y una categoría hija</strong>', 'nichecreator'),
        'contenidoborrado' => __('Vas a lanzar un proceso de borrado. Esta operación es irreversible.', 'nichecreator'),
        'contenidoborradofichas' => __('Vas a lanzar un proceso de borrado. Esta operación es irreversible.', 'nichecreator'),
        'contenidoarreglos' => __('Vas a sobreescribir el contenido del campo escogido. Esta operación es irreversible.', 'nichecreator'),
        'contenidoborrarduplicados' => __('Vas a lanzar un proceso de borrado de duplicados. Esta operación es irreversible.', 'nichecreator'),
        'contenidoborradocats' => __('Vas a lanzar un proceso de borrado. Esta operación es irreversible.', 'nichecreator'),
        'contenidoimagenes' => __('Vas a importar las imágenes escrapeadas en tu servidor. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso.', 'nichecreator'),
        'contenidoimagenesia' => __('Vas a generar imágenes con IA. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso.', 'nichecreator'),
        'contenidoimagenescat' => __('Vas a generar imágenes con IA. Verás un indicador de estado de proceso en todo momento. En cualquier caso, aunque salgas de la página el proceso seguirá su curso.', 'nichecreator'),
        'contenidoasignarpost' => __('Vas a asignar este post a todas las categorías de tu web.', 'nichecreator'),
        'contenidoescrapeos' => __('Vas a lanzar un proceso de escrapeo de datos. Los resultados serán visibles en el Editor de Fichas.', 'nichecreator'),
        'contenidosustitucion' => __('Vas a lanzar un proceso de sustitución de datos. Esta operación es irreversible.', 'nichecreator'),
        'contenidoetiquetas' => __('Vas a lanzar un proceso de asociación de etiquetas. Esta operación es irreversible.', 'nichecreator'),
        'contenidocategorias' => __('Vas a lanzar un proceso de asocicación de categorías. Esta operación es irreversible.', 'nichecreator'),
        'contenidogeografico' => __('Vas a lanzar el proceso de carga de datos geográficos. El proceso se ejecutará en fondo.', 'nichecreator'),
    ];

    // Encolar estilos
    wp_enqueue_style('nichecreator', plugins_url('/css/nichecreator.css', __FILE__), [], '1.4');
    wp_enqueue_style('wp-jquery-ui-dialog');

    // Encolar scripts
    wp_enqueue_script('wp-i18n');
    wp_enqueue_script('clipboard', plugins_url('/js/clipboard.min.js', __FILE__), ['jquery', 'wp-i18n'], '1.0', true);
    wp_add_inline_script(
        'clipboard',
        'jQuery(document).ready(function($) { new ClipboardJS(".btn"); });',
        'after'
    );

    wp_enqueue_script('ui-consulta', plugins_url('/js/llamadadialog.js', __FILE__), ['jquery', 'jquery-ui-dialog', 'wp-i18n'], '1.0', true);
    wp_localize_script('ui-consulta', 'nichecreator_translations', $translations);
    wp_set_script_translations('ui-consulta', 'nichecreator', plugin_dir_path(__FILE__) . 'languages');

    wp_enqueue_script('ocultar-mostrar', plugins_url('/js/botones.js', __FILE__), ['jquery', 'wp-i18n'], '1.0', true);
    wp_localize_script('ocultar-mostrar', 'nichecreator_botones', $botones);
    wp_set_script_translations('ocultar-mostrar', 'nichecreator', plugin_dir_path(__FILE__) . 'languages');
}

////////////////CSS y JS///////////////////

//////////////////////////////////////
//////// HOOKS /////////////////////
/////////////////////////////////////



global $wpdb;
$tabla = $wpdb->prefix.'niche_tabla';

$resultado = update_option('nichecreator_offsetscrape',5,true);
$resultado = update_option('nichecreator_offsetcats',2,true);
$resultado = update_option('nc_offset',5,true);
$resultado = update_option('nichecreator_offsetimagenesia',5,true);

// FOOTER ///
require_once 'footer.php';

// Otras funciones
require_once 'ficheros/ficheros.php';

// Hooks varios
require_once 'hooks/hooks.php';
require_once 'cargardatosgeograficos.php';

require_once 'header/header.php';


// Shortcodes
require_once 'shortcodes/shortcode.php';

// Mensajes de error
require_once 'errores/mensajes.php';

//Página de integraciones..
require_once 'pages/integraciones.php';
require_once 'pages/kude.php';

// Settings categorias..
require_once 'pages/settingscat.php';

// Pagina editor
require_once 'pages/editor.php';

// Página de clonación de páginas...
require_once 'pages/clonado.php';

// Página de limpieza
require_once 'pages/limpieza.php';

//Página de imaǵenes
require_once 'pages/imagenes.php';

// Pagina de plantillas
require_once 'pages/templates.php';

// Obtención de datos
require_once 'pages/datos.php';

require_once 'sql/lanzarcargatabla.php';

// Widget
require_once plugin_dir_path(__FILE__).'widgets/widget.php';

// Custom Post Type
require_once plugin_dir_path(__FILE__).'customtemplate/custompost.php';

///////////////////////
// METABOXES EN CUSTOM POST TYPE //
require_once 'metaboxes/metaboxes.php';

// FIN METABOXES //
// Select de campos...
require_once 'includes/recuperarselect.php';


function rook_master()
{
$pagina = isset($_GET['page']) ? sanitize_text_field($_GET['page']) : '';


if (str_contains($pagina,'nichecreator') AND !str_contains($pagina,'license'))
{
$var = nc_sample_check_license();
if (!$var)
	{
	$redirect = add_query_arg(
			array(
				'page'          => 'nichecreator_license',
				'sl_activation' => 'false',
				'message'       => __('No tienes una licencia válida','nichecreator'),
			),
			admin_url( 'admin.php' )
		);
		wp_safe_redirect( $redirect );
		exit();
	}
}
}
//add_action('admin_init','rook_master');


/////////////////////////////////////////////////////////////
/////////// MENU ////////////////////////////////////////////
/////////////////////////////////////////////////////////////

if (!function_exists('niche_options_page'))
{
	function niche_options_page()
	{
	    
	 /* ———————————  MENÚ PRINCIPAL  ——————————— */
	add_menu_page(
		'Niche Creator',                 // Título de la página
		'Niche Creator',                 // Texto que se ve en la barra lateral
		'manage_options',                // Capacidad
		'nichecreator_creator',          // Slug (lo dejamos para no romper nada)
		'nichecreator_datos',            // Callback → mostrará “Obtención de datos”
		'dashicons-networking',
		15
	);

	/* ———————————  SUBMENÚS REALES  ——————————— */
	add_submenu_page(
		'nichecreator_creator',
		__( 'Obtener datos', 'nichecreator' ),
		__( 'Obtener datos', 'nichecreator' ),
		'manage_options',
		'nichecreator_datos',
		'nichecreator_datos'
	);
	add_submenu_page( 'nichecreator_creator', __( 'Gestión de fichas',    'nichecreator' ), __( 'Limpiar datos',     'nichecreator' ), 'manage_options', 'nichecreator_limpieza',          'nichecreator_limpieza'           );
	add_submenu_page( 'nichecreator_creator', __( 'Categorías',           'nichecreator' ), __( 'Crear categorías',      'nichecreator' ), 'manage_options', 'nichecreator_settingscat',       'nichecreator_settingscat'        );
	add_submenu_page( 'nichecreator_creator', __( 'Importación imágenes', 'nichecreator' ), __( 'Generar imágenes','nichecreator' ), 'manage_options', 'nichecreator_imagenes',          'nichecreator_imagenes'           );
	add_submenu_page( 'nichecreator_creator', __( 'Clonación',            'nichecreator' ), __( 'Crear fichas',    'nichecreator' ), 'manage_options', 'nichecreator_creator_pages',     'nichecreator_creator_page'       );
	add_submenu_page( 'nichecreator_creator', __( 'Editor',               'nichecreator' ), __( 'Editor de fichas',      'nichecreator' ), 'manage_options', 'nichecreator_editor',           'nichecreator_editor'            );
	add_submenu_page( 'nichecreator_creator', __( 'Plantillas Cat',       'nichecreator' ), __( 'Plantillas de categoría',  'nichecreator' ), 'manage_options', 'edit.php?post_type=nichocat',     false                              );
	add_submenu_page( 'nichecreator_creator', __( 'Plantillas',           'nichecreator' ), __( 'Plantillas de ficha',     'nichecreator' ), 'manage_options', 'edit.php?post_type=nicho',        false                              );
	add_submenu_page( 'nichecreator_creator', __( 'Opciones',             'nichecreator' ), __( 'Opciones generales',              'nichecreator' ), 'manage_options', 'nichecreator_integraciones',     'nichecreator_integraciones'      );
	add_submenu_page( 'nichecreator_creator', __( 'Licencia',             'nichecreator' ), __( 'Licencia',              'nichecreator' ), 'manage_options', 'nichecreator_license',           'nc_sample_license_page'          );

 	}


 /* ——————————————————  QUITAR el sub-ítem duplicado  —————————————————— */
add_action( 'admin_menu', function () {
	remove_submenu_page( 'nichecreator_creator', 'nichecreator_creator' );
}, 999 );

/* ——————————————————  Resaltar correctamente el menú padre —————————————————— */
add_filter( 'parent_file', function ( $parent_file ) {
	if ( isset( $_GET['page'] ) && $_GET['page'] === 'nichecreator_datos' ) {
		$parent_file = 'nichecreator_creator';
	}
	return $parent_file;
} );

	add_action('admin_menu','niche_options_page');
}

function actualizar_escrapeo_inicial() {
    global $wpdb;
    $tabla = $wpdb->prefix .'niche_tabla';
        // Actualiza filas donde 'escrapeo' está vacío o NULL
        $wpdb->query("UPDATE $tabla SET escrapeo = 'ESCRAPEO_Inicial' WHERE escrapeo IS NULL OR escrapeo = ''");
}

