document.addEventListener("DOMContentLoaded", function () {
  const indicator = document.getElementById("stepIndicatorAdmin");
  const currentStep = indicator ? parseInt(indicator.dataset.currentStep) : 1;

  document.querySelectorAll("#stepIndicatorAdmin .step").forEach(step => {
    const stepNum = parseInt(step.dataset.step);
    if (stepNum < currentStep) {
      step.classList.add("completed");
    } else if (stepNum === currentStep) {
      step.classList.add("active");
    }
    else 
    	{
    	step.classList.remove("completed");
    	}
  });
});


