document.addEventListener('DOMContentLoaded', function () {
    const select = document.getElementById('selecesc');

    if (select) {
        select.addEventListener('change', function () {
            const selectedValue = this.value;
            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'verificar_escrapeo_fichas',
                    escrapeo: selectedValue
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const h1 = data.data.h1;
                    const metatitle = data.data.metatitle;
		    const metadesc = data.data.metadesc;
                    document.getElementById('h1fich').style.display = h1 ? 'flex' : 'none';
                    document.getElementById('metatitlefich').style.display = metatitle ? 'flex' : 'none';
					document.getElementById('metadescfich').style.display = metadesc ? 'flex' : 'none';
                } else {
                    // Opcional: ocultar todo si falla
                    document.getElementById('h1fich').style.display = 'none';
                    document.getElementById('metatitlefich').style.display = 'none';
		    document.getElementById('metadescfich').style.display = 'none';
                }
            });
        });

        // Disparar una vez al cargar (por si hay valor preseleccionado)
        select.dispatchEvent(new Event('change'));
    }
});

