document.addEventListener('DOMContentLoaded', function () {
    const select = document.getElementById('selecesc');

    if (select) {
        select.addEventListener('change', function () {
            const selectedValue = this.value;
            fetch(ajaxurl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: new URLSearchParams({
                    action: 'verificar_escrapeo_campos',
                    escrapeo: selectedValue
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const mostrarPadres = data.data.tiene_categoriapadre;
                    const mostrarHijas = data.data.tiene_searchrequest;
                    document.getElementById('padre_advanced').style.display = mostrarPadres ? 'block' : 'none';
                    document.getElementById('hijas_advanced').style.display = mostrarHijas ? 'block' : 'none';
                } else {
                    // Opcional: ocultar todo si falla
                    document.getElementById('padre_advanced').style.display = 'none';
                    document.getElementById('hijas_advanced').style.display = 'none';
                }
            });
        });

        // Disparar una vez al cargar (por si hay valor preseleccionado)
        select.dispatchEvent(new Event('change'));
    }
});

