//const { __, _x, _n, _nx } = wp.i18n;
//var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
jQuery(document).ready(function($){
    const botonImportar = document.getElementById('importar-sql-lotes');
    const contenedorMensajes = document.getElementById('mensajes-importacion');

    let tablas = ['regions','subregions','countries', 'states','cities'];
    let index = 0;

    if (botonImportar && contenedorMensajes) {
        botonImportar.addEventListener('click', function() {
            botonImportar.disabled = true;
            contenedorMensajes.innerHTML = '<p>🟡 Iniciando importación...</p>';
            importarTodo();
        });
    }

function logMensaje(mensaje, tipo = 'info') {
    let mensajeActual = document.getElementById('mensaje-actual');
    if (!mensajeActual) {
        mensajeActual = document.createElement('p');
        mensajeActual.id = 'mensaje-actual';
        contenedorMensajes.appendChild(mensajeActual);
    }
    mensajeActual.textContent = mensaje;
    switch (tipo) {
        case 'error':
            mensajeActual.style.color = 'red';
            break;
        case 'success':
            mensajeActual.style.color = 'green';
            break;
        default:
            mensajeActual.style.color = 'black';
    }
}
    function importarTodo() {
        index = 0;
        importarTabla(tablas[index]);
    }
    function importarTabla(tabla) {
        let offset = 0;
        function importarLote() {
            jQuery.ajax({
                url:obj.ajaxurl,
                method: 'POST',
                dataType: 'json',
                data: {
                    //action: 'mi_plugin_ajax_importar_lotes_csv',
                    tabla: tabla,
                    offset: offset
                },
                success: function(response) {
                    if (response.success) {
                        logMensaje(`✅ Tabla: ${tabla}, procesadas: ${offset}, offset: ${response.data.procesadas}`);
                        if (!response.data.fin) {
                            offset = response.data.siguiente_offset;
                            importarLote();
                        } else {
                            logMensaje(`✅ ¡Importación de ${tabla} terminada!`, 'success');
                            index++;
                            if (index < tablas.length) {
                                importarTabla(tablas[index]);
                            } else {
                                logMensaje('🎉 ¡Todas las tablas importadas!', 'success');
                                botonImportar.disabled = false;
                            }
                        }
                    } else {
                        let errorMsg = (response.data && response.data.mensaje) ? response.data.mensaje : JSON.stringify(response.data || 'Error desconocido');
			logMensaje(`❌ Error importando ${tabla}: ${errorMsg}`, 'error');
                        botonImportar.disabled = false;
                    }
                },
                error: function(xhr, status, error) {
                    console.log(xhr.responseText);  // Ver la respuesta completa
    		    //console.log(error);
                    logMensaje(`❌ AJAX error: ${error}`, 'error');
                    botonImportar.disabled = false;
                }
            });
        }
        importarLote();
    }
});
