<?php
include plugin_dir_path(__FILE__).'../includes/libraries/Parser.php';
include plugin_dir_path(__FILE__).'../includes/libraries/Parsers/SimpleXML.php';
include plugin_dir_path(__FILE__).'../includes/libraries/Parsers/Regex.php';
include plugin_dir_path(__FILE__).'../includes/libraries/Parsers/XML.php';
use HJBDev\PHPWordpressXMLParser\Parser;
// Función para importar posts desde un archivo XML
function importar_posts_desde_xml($fichero) {
    $errores = 0;
    $output = Parser::parse($fichero);

    foreach ($output["posts"] as $post) {
        $titulo = sanitize_text_field($post["post_title"]);
        $contenido = addslashes($post["post_content"]);
        $status = $post["status"];

        // Buscar si ya existe un post con el mismo título y tipo
        $post_existente = get_page_by_title( $titulo, OBJECT, 'nicho' );

        if ( $post_existente ) {
            // Ya existe, saltamos este
            continue;
        }

        $nuevo_post = array(
            'post_title'   => $titulo,
            'post_content' => wp_slash($contenido),
            'post_status'  => $status,
            'post_type'    => 'nicho',
            'post_author'  => 1 // ID del autor del post
        );

        $post_id = wp_insert_post( $nuevo_post );

        if ( ! $post_id ) {
            $errores = 1;
        }
    }

    return $errores === 0;
}

// Importar posts del tipo plantilla categoria

function importar_postscat_desde_xml($fichero) {
    $errores = 0;
    $output = Parser::parse($fichero);

    foreach ($output["posts"] as $post) {
        $titulo = sanitize_text_field($post["post_title"]);
        $contenido = $post["post_content"];
        $status = $post["status"];

        // Verifica si ya existe un post con el mismo título y tipo 'nichocat'
        $post_existente = get_page_by_title( $titulo, OBJECT, 'nichocat' );

        if ( $post_existente ) {
            // Ya existe, saltar este post
            continue;
        }

        $nuevo_post = array(
            'post_title'   => $titulo,
            'post_content' => wp_slash($contenido),
            'post_status'  => $status,
            'post_type'    => 'nichocat',
            'post_author'  => 1 // ID del autor
        );

        $post_id = wp_insert_post( $nuevo_post );

        if ( ! $post_id ) {
            $errores = 1;
        }
    }

    return $errores === 0;
}

